
// define our varying texture coordinates
varying vec2 texcoord0;
varying vec2 texcoord1;

// set repos amount
uniform vec2 amt;

// define our rectangular texture samplers
uniform sampler2DRect tex0;
uniform sampler2DRect tex1;

void main (void)
{
	
	// sample repos map from 2nd input
	vec4 input0 = texture2DRect(tex0, texcoord0);
	vec2 input1 = texture2DRect(tex1, texcoord1).xy;

	// calculate new position based on map
	vec2 repos = texcoord0+(input1 * amt);

	// sample the texture from input0	
	vec4 spots_fc = texture2DRect(tex0, repos);

	// write the data to the fragment color
	gl_FragColor = spots_fc;
}
